<?php
// Determinar o domínio atual dinamicamente
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? "https://" : "http://";
$domain = $_SERVER['HTTP_HOST'];

// Pegar o caminho completo da requisição
$requestUri = $_SERVER['REQUEST_URI'];

// Extrair o caminho relativo até a raiz (removendo o nome do arquivo atual e a pasta /api)
$basePath = dirname($requestUri);
$rootPath = str_replace('/api', '', $basePath); // Remove /api do caminho
$rootPath = $rootPath === '/' ? '' : $rootPath; // Ajusta para evitar barra dupla

// Construir a URL completa para renovar.php antes da pasta /api
$paymentUrl = $protocol . $domain . ($rootPath ? '/' . ltrim($rootPath, '/') : '') . '/api/payment/payment_go.php';

// Gerar a URL do QR Code usando a API do qrserver.com
$qrCodeUrl = "https://api.qrserver.com/v1/create-qr-code/?size=200x200&data=" . urlencode($paymentUrl);
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Renovar QR Code</title>
    <style>
        body {
            background-color: #1a1a1a;
            color: #fff;
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 0;
        }
        .container {
            text-align: center;
            padding: 20px;
            max-width: 600px;
            margin: 0 auto;
        }
        h2 {
            color: #ccc;
            font-size: 1.5rem;
            margin: 15px 0;
            line-height: 1.5;
        }
        .qr-code {
            margin: 30px 0;
            background: #fff;
            padding: 10px;
            display: inline-block;
            border-radius: 5px;
        }
        .qr-code img {
            display: block;
        }
    </style>
</head>
<body>
    <div class="container">
        <h2>Abra a câmera do seu celular 📱</h2>
        <h2>Confira nossas promoções!</h2>

        <div class="qr-code">
            <img src="<?php echo $qrCodeUrl; ?>" alt="QR Code para Pagamento">
        </div>
    </div>
</body>
</html>