<!DOCTYPE html>
<html>
<head>
    <title>Banner Manual</title>
    <style>
        body {
            margin: 0;
            padding: 0;
            background-color: black;
            overflow: hidden;
        }
        #slideshow {
            position: relative;
            width: 100vw;
            height: 100vh;
            overflow: hidden;
            background-color: black;
        }
        img, video {
            position: absolute;
            top: 0;
            left: 100%;
            width: 100vw;
            height: 100vh;
            object-fit: contain;
            opacity: 0;
            transition: opacity 1s ease-in-out, left 1s ease-in-out;
        }
    </style>
</head>
<body>
    <div id="slideshow"></div>

    <script>
        var slideshow = document.getElementById("slideshow");

        fetch('ads.php')
            .then(response => response.json())
            .then(data => {
                var mediaUrls = data.map(obj => obj.AdUrl);
                loadSlides(mediaUrls);
            });

        function getMediaType(url) {
            var extension = url.split('.').pop();
            return ["jpg", "jpeg", "png", "gif"].includes(extension) ? "image" : extension === "mp4" ? "video" : null;
        }

        function loadSlides(mediaUrls) {
            mediaUrls.forEach(url => {
                let mediaType = getMediaType(url);
                let slideElement = document.createElement(mediaType === "image" ? "img" : "video");
                slideElement.src = url;
                if (mediaType === "video") {
                    slideElement.autoplay = true;
                    slideElement.muted = true;
                    slideElement.controls = false;
                    slideElement.loop = false;
                    slideElement.addEventListener('ended', showSlides);
                }
                slideshow.appendChild(slideElement);
            });
            showSlides();
        }

        let slideIndex = 0;
        function showSlides() {
            let slides = slideshow.children;
            [...slides].forEach(slide => {
                slide.style.opacity = 0;
                slide.style.left = "100%";
            });

            slideIndex = (slideIndex + 1) % slides.length;
            let currentSlide = slides[slideIndex];
            currentSlide.style.opacity = 1;
            currentSlide.style.left = "0";

            if (currentSlide.tagName === "IMG") {
                setTimeout(showSlides, 8000);
            }
        }
    </script>
</body>
</html>
