<?php
$api_key = 'ec8237f367023fbadd38ab6a1596b40c';
$url = "https://api.themoviedb.org/3/trending/movie/week?api_key=$api_key&language=pt-BR";

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
$response = curl_exec($ch);
curl_close($ch);

$data = json_decode($response, true);
$movies = array_slice($data['results'], 0, 5);

foreach ($movies as $key => $movie) {
    $movie_id = $movie['id'];
    $details_url = "https://api.themoviedb.org/3/movie/$movie_id?api_key=$api_key&language=pt-BR";

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $details_url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $details_response = curl_exec($ch);
    curl_close($ch);

    $details = json_decode($details_response, true);
    $movies[$key]['runtime'] = $details['runtime'] ?? 90;
    $movies[$key]['release_date'] = $details['release_date'] ?? 'Data desconhecida';
    $movies[$key]['genres'] = isset($details['genres']) ? array_column($details['genres'], 'name') : [];
}
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
  <meta charset="UTF-8" />
  <title>https://flix-play.com/apks</title>
  <style>
    * {
      margin: 0;
      padding: 0;
      box-sizing: border-box;
    }
    body, html {
      height: 100vh;
      margin: 0;
      background: linear-gradient(to bottom, #000000, #2e2e2e 50%, #000000 100%);
      color: #fff;
      font-family: Arial, sans-serif;
      overflow: hidden;
    }
    main {
      width: 100%;
      height: 100%;
      position: relative;
      display: flex;
      align-items: center;
      justify-content: space-between;
    }
.movie-section {
  position: absolute;
  top: 40px;
  right: 50px;
  width: 50%;
  height: auto;
  max-height: 500px;
  display: flex;
  align-items: flex-start;
  justify-content: flex-end;
  opacity: 0;
  transition: opacity 1s ease-in-out;
  pointer-events: none;
}
    .movie-section.active {
      opacity: 1;
      pointer-events: auto;
    }
.movie-box {
  display: flex;
  align-items: center;
  justify-content: flex-end;
  flex-direction: row;
  max-width: 700px;
  width: 100%;
  gap: 20px;
}
    .poster img {
      max-height: 250px;
      border-radius: 10px;
    }
.content {
  text-align: right;
  margin-right: 20px;
  width: 100%;
  max-width: 500px;
}
    .content h1 {
      font-size: 16px;
      color: #ffd966;
      margin-bottom: 8px;
    }
    .description {
      font-size: 14px;
      line-height: 1.3;
      color: #ccc;
    }
    .banner-frame {
      position: fixed;
      left: 50px;
      top: 40px;
      border: none;
      background: transparent;
      z-index: 10;
      width: 220px;
      height: 300px;
      max-height: 90vh;
    }
  </style>
</head>
<body>
  <main>
    <?php foreach ($movies as $index => $movie):
      $title = $movie['title'];
      $overview = mb_strimwidth($movie['overview'], 0, 150, '...');
      $poster = 'https://image.tmdb.org/t/p/w300' . $movie['poster_path'];

      // Ano de lançamento
      $release_year = isset($movie['release_date']) ? substr($movie['release_date'], 0, 4) : 'Ano desconhecido';

      // Gêneros
      $genre_list = !empty($movie['genres']) ? implode(' - ', $movie['genres']) : 'Gênero desconhecido';
    ?>
    <section class="movie-section<?= $index === 0 ? ' active' : '' ?>">
      <div class="movie-box">
        <div class="content">
          <h1><?= htmlspecialchars($title) ?></h1>
<div style="color: #ff4d4d; font-size: 13px; margin-bottom: 5px; font-weight: bold;">
  <?= htmlspecialchars($release_year) ?> - <?= htmlspecialchars($genre_list) ?>
</div>
          <div class="description"><?= htmlspecialchars($overview) ?></div>
        </div>
        <div class="poster">
          <img src="<?= $poster ?>" alt="Poster do filme <?= htmlspecialchars($title) ?>" loading="lazy">
        </div>
      </div>
    </section>
    <?php endforeach; ?>
  </main>

  <iframe
    src=""
    class="banner-frame"
    id="bannerIframe"
    allowtransparency="true"
    scrolling="no"
  ></iframe>

  <script>
    document.addEventListener("DOMContentLoaded", () => {
      const sections = document.querySelectorAll(".movie-section");
      let currentIndex = 0;

      function showNextSection() {
        sections[currentIndex].classList.remove("active");
        currentIndex = (currentIndex + 1) % sections.length;
        sections[currentIndex].classList.add("active");
      }

      sections[currentIndex].classList.add("active");
      setInterval(showNextSection, 10000);
    });
  </script>
</body>
</html>
